
typedef enum { EEE_Idle = 0,
               EEE_Erase,
               EEE_RAMBufCopyInit,
               EEE_RAMBufCopy,
               EEE_BlankCheck,
               EEE_ProgData

             } EEE_State;


typedef enum { EEE_noErr = 0,
               EEE_EraseErr,
               EEE_BlankCheckErr,
               EEE_ProgErr,
               EEE_BadAddress,
               EEE_Busy,
               EEE_FlushBufferErr,
               EEE_CantSuspend

             } EEE_Error;

typedef struct {
                unsigned char Status;
                unsigned char Data[255];
               
               } DFSector, *DFSectorP;

typedef unsigned char Boolean;

#define BusClock 8000				/* Bus clock in kHz, default is 8 MHz using the internal reference */

#define GlobalOffset 0x00004000l		/* Global address 'offset' to DFlash */
#define DFStart 0x1100				/* Start address of first DFlash Sector to use for EEE */
#define DFEnd   0x13ff				/* End address of last DFlash Sector to use for EEE */
#define DFSize  ((DFEnd - DFStart) + 1)		/* size of the DFlash (in bytes) used for EEE */
#define DFSectorSize 256			/* DFlash sector size */
#define DFNumSectors (DFSize / DFSectorSize)	/* Total number of DFlash sectors being used for EEE (must be a minimum of 3) */
#define DFMaxSectorNum (DFNumSectors - 1)	/* last sector number (index) */

#define EEERAMStart 0x3f00			/* EEE RAM buffer start address */
#define EEERAMEnd   0x3fff			/* EEE RAM buffer end address */

#define ActiveSectorFlag 0xaa			/* Sector valid flag byte value */

#define DFEraseVerfCmd   0x10
#define DFProgramCmd     0x11
#define DFEraseSectorCmd 0x12

#define DelayedWriteFlag 0x80			/* indicates EEE 'Delayed write' state when EEERAMStart[0] MSb is set */

extern volatile EEE_State EEEState;		/* current state of the EEE */
extern volatile EEE_Error EEEError;		/* error state of EEE. valid when EEEState == EEE_Idle */

#if DFNumSectors < 3
#error "EEE Routines Require A Minimum Of 3 Sectors"
#endif

#if (DFStart >= DFEnd)
#error "DFStart address is greater than or equal to DFEnd"
#endif

#if (DFStart & 0x00ff) != 0
#error "Lower 8-bits of DFlash Start Address Must Be 0x00"
#endif

#if (DFEnd & 0x00ff) != 0x00ff
#error "Lower 8-bits of DFlash End Address Must Be 0xff"
#endif

#if (EEERAMStart >= EEERAMEnd)
#error "EEERAMStart address is greater than or equal to EEERAMEnd"
#endif

#if ((EEERAMEnd - EEERAMStart) + 1) != 256
#error "EEE RAM buffer must be EXACTLY 256 bytes"
#endif
